<?php
// Allow CORS requests
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Include database connection file
require_once '../config.php'; 

// Check if request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the input data
    $identifier = $_POST['identifier']; // Phone or email
    $password = $_POST['password'];
    $isPhoneLogin = $_POST['isPhoneLogin']; // Check if login is by phone or email

    // Prepare SQL statement to check user existence
    if ($isPhoneLogin == 'true') {
        $sql = "SELECT id, password, type FROM users WHERE phone = ?";
    } else {
        $sql = "SELECT id, password, type FROM users WHERE email = ?";
    }

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param('s', $identifier);
        $stmt->execute();
        $result = $stmt->get_result();

        // Check if user exists
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();

            // Verify the password
            if (password_verify($password, $user['password'])) {
                $response = [
                    "success" => true,
                    "message" => "Login successful",
                    "user_id" => $user['id'],
                    "user_type" => $user['type']
                ];

                // If user type is 1, check for shop
                if ($user['type'] == 1) {
                    $shopSql = "SELECT id FROM shops WHERE user_id = ? LIMIT 1";
                    if ($shopStmt = $conn->prepare($shopSql)) {
                        $shopStmt->bind_param('i', $user['id']);
                        $shopStmt->execute();
                        $shopResult = $shopStmt->get_result();

                        if ($shopResult->num_rows > 0) {
                            $shop = $shopResult->fetch_assoc();
                            $response["shop_id"] = $shop['id'];
                        }
                        $shopStmt->close();
                    }
                }

                echo json_encode($response);
            } else {
                echo json_encode(["success" => false, "message" => "Incorrect password"]);
            }
        } else {
            echo json_encode(["success" => false, "message" => "User not found"]);
        }

        // Close the statement
        $stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "Database query failed"]);
    }

    // Close the connection
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}
