<?php
require_once '../config.php'; // Hakikisha njia ni sahihi

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Pata data ya kawaida
    $shop_name = isset($_POST['shop_name']) ? $_POST['shop_name'] : '';
    $location = isset($_POST['location']) ? $_POST['location'] : '';
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : '';

    if(empty($shop_name) || empty($location) || empty($user_id)) {
        echo json_encode(["success" => false, "message" => "Missing required fields"]);
        exit;
    }

    // Tarajia directory za kuhifadhi images
    $coverDir = "../uploads/shops/covers/";
    $profileDir = "../uploads/shops/profiles/";

    // Hakikisha folders zipo
    if (!file_exists($coverDir)) {
        mkdir($coverDir, 0777, true);
    }
    if (!file_exists($profileDir)) {
        mkdir($profileDir, 0777, true);
    }

    $coverImageName = "";
    $profileImageName = "";

    // Process cover image ikiwa imetumwa
    if(isset($_FILES['cover_image']) && $_FILES['cover_image']['error'] == 0) {
        $coverExt = pathinfo($_FILES['cover_image']['name'], PATHINFO_EXTENSION);
        $coverImageName = uniqid('cover_', true) . '.' . $coverExt;
        $coverTarget = $coverDir . $coverImageName;
        if(!move_uploaded_file($_FILES['cover_image']['tmp_name'], $coverTarget)) {
            echo json_encode(["success" => false, "message" => "Failed to upload cover image"]);
            exit;
        }
    }

    // Process profile image ikiwa imetumwa
    if(isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] == 0) {
        $profileExt = pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION);
        $profileImageName = uniqid('profile_', true) . '.' . $profileExt;
        $profileTarget = $profileDir . $profileImageName;
        if(!move_uploaded_file($_FILES['profile_image']['tmp_name'], $profileTarget)) {
            echo json_encode(["success" => false, "message" => "Failed to upload profile image"]);
            exit;
        }
    }

    // Insert data katika database
    $stmt = $conn->prepare("INSERT INTO shops (shop_name, location, user_id, cover_image, profile_image, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("sssss", $shop_name, $location, $user_id, $coverImageName, $profileImageName);
    
    if($stmt->execute()){
        echo json_encode(["success" => true, "message" => "Shop created successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Database insertion failed"]);
    }
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}
?>
